package gov.va.genisis2.DatabaseTableCopy;

import static org.junit.Assert.assertEquals;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

/**
 * @author PII
 *
 */
public class DatabaseTableCopyTest {
	/**
	 * Initialize variables to read the message output by DatabaseTableCopy.
	 */
	private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
	private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();

	/**
	 * Set variables to catch the messages in both out and err print streams.
	 */
	@Before
	public void setUpStreams() {
		System.setOut(new PrintStream(outContent));
		System.setErr(new PrintStream(errContent));

	}

	/**
	 * Clear variables of the messages in both out and err print streams.
	 */
	@After
	public void cleanUpStreams() {
		System.setOut(null);
		System.setErr(null);
	}

	/**
	 * Test case with wrong amount of arguments
	 */
	@Test
	@Ignore
	public void testMainWithWrongArgsAmount() {
		DatabaseTableCopy.main(new String[] { "NaN" });
		String expectedMessage = "Wrong amount of arguments.";
		System.err.println(expectedMessage);
		assertEquals(errContent.toString(), outContent.toString());
		System.out.println(outContent.toString());
	}

	/**
	 * Test case with multiple tables which also covers single table case due to
	 * nature of DatabaseTableCopy.
	 */
	@Test
	@Ignore
	public void testMainWithCorrectTable() {
		DatabaseTableCopy.main(new String[] { "IP         ", "GENISISDATASOURCE", "dflt", "IP         ", "data_ops",
				"genisis20!7", "GENISISDATADEST", "dbo", "IP         ", "data_ops", "genisis20!7", "Genisis_Db_Dev",
				"Genisis_ops_tempdata", "dbo", "vinciTable5" });
		String expectedMessage = "Successfully copied table: 'vinciTable5' ";
		System.err.println(expectedMessage);
		assertEquals(errContent.toString(), outContent.toString());
		System.out.println(outContent.toString());
	}

	/**
	 * Test case with wrong table name to test table path correctness.
	 */
	@Test
	@Ignore
	public void testMainWithWrongTable() {
		DatabaseTableCopy.main(new String[] { "IP         ", "GENISISDATASOURCE", "dbo", "IP         ", "data_ops",
				"genisis20!7", "GENISISDATADEST", "dbo", "IP         ", "data_ops", "genisis20!7", "Genisis_Db_Dev",
				"Genisis_ops_tempdata", "dbo", "wrongTable" });
		String expectedMessage = "wrongTable cannot be found. Please enter in a valid table name for the table to be copied.";
		System.err.println(expectedMessage);
		assertEquals(errContent.toString(), outContent.toString());
		System.out.println(outContent.toString());
	}

	/**
	 * Test case with wrong source schema to test table path correctness.
	 */
	@Test
	@Ignore
	public void testMainWithWrongSourceSchema() {
		DatabaseTableCopy.main(new String[] { "IP         ", "GENISISDATASOURCE", "wrong", "IP         ", "data_ops",
				"genisis20!7", "GENISISDATADEST", "dbo", "IP         ", "data_ops", "genisis20!7", "Genisis_Db_Dev",
				"Genisis_ops_tempdata", "dbo", "vinciTable5" });
		String expectedMessage = "wrong cannot be found. Please enter in a valid Source schema name for the table to be copied.";
		System.err.println(expectedMessage);
		assertEquals(errContent.toString(), outContent.toString());
		System.out.println(outContent.toString());
	}

	@Test
	@Ignore
	public void testMainWithWrongTableSchema() {
		DatabaseTableCopy.main(new String[] { "IP         ", "GENISISDATASOURCE", "dbo", "IP         ", "data_ops",
				"genisis20!7", "GENISISDATADEST", "StudyMart1", "IP         ", "data_ops", "genisis20!7",
				"Genisis_Db_Dev", "Genisis_ops_tempdata", "dbo", "vincitable1" });
		String expectedMessage = "vincitable1 does not exist for the Schema dbo.";
		System.err.println(expectedMessage);
		assertEquals(errContent.toString(), outContent.toString());
		System.out.println(outContent.toString());
	}

	/**
	 * Test case with wrong destination schema to test table path correctness.
	 */
	@Test
	@Ignore
	public void testMainWithWrongDestSchema() {
		DatabaseTableCopy.main(new String[] { "IP         ", "GENISISDATASOURCE", "dflt", "IP         ", "data_ops",
				"genisis20!7", "GENISISDATADEST", "wrong", "IP         ", "data_ops", "genisis20!7", "Genisis_Db_Dev",
				"Genisis_ops_tempdata", "dbo", "vinciTable5" });
		String expectedMessage = "wrong cannot be found. Please enter in a valid Destination schema name for the table to be copied.";
		System.err.println(expectedMessage);
		assertEquals(errContent.toString(), outContent.toString());
		System.out.println(outContent.toString());
	}

	/**
	 * Test case with wrong usernames and passwords to test access issues.
	 */
	@Test
	@Ignore
	public void testMainWithWrongLogins() {
		DatabaseTableCopy.main(new String[] { "IP         ", "GENISISDATASOURCE", "dbo", "IP         ", "wrong",
				"wrong", "GENISISDATADEST", "dbo", "IP         ", "wrong", "wrong", "Genisis_Db_Dev",
				"Genisis_ops_tempdata", "dbo", "vinciTable5" });
		String expectedMessage = "An error occurred during transfer. Please contact your system administrator.";
		System.err.println(expectedMessage);
		assertEquals(errContent.toString(), outContent.toString());
		System.out.println(outContent.toString());
	}

}
